/********************************
 *  keyf[^MiI2CX[uj
 * @Slave Address = 0x40
 ********************************/
#include "mcc_generated_files/mcc.h"
#define	SCN_DELAY() __delay_ms(30)
#define	KEY_DELAY() __delay_ms(500)

uint8_t  wState;         	// I2C݃Xe[gԍ
uint8_t  rState;          	// I2CǍXe[gԍ
uint16_t rDat;            	// I2CM16rbgf[^
uint8_t  keyStat;          	// L[͏
uint16_t keyM;            	// L[}gNXf[^
uint8_t  keyP;            	// L[f[^i1|12)
uint16_t keyDat;			// }gNX{f[^
uint8_t  k[] = {'0','1','4','7',
                '.','2','5','8',
               '\r','3','6','9'}; 	// eL[z
/*
uint8_t  k[] = {'*','7','4','1',
                '0','8','5','2',
                '#','9','6','3'};	// db@z  
*/
/*****  I2C Read Callback  ****************/
void I2C1_ReadProcess(void) {
    switch (rState) {           // Xe[gŐi
        case 0:
            rDat = (uint16_t)I2C1_Read();
            rState++;          // 1byteړǍA
            break;
        case 1:
            rDat |= (uint16_t)I2C1_Read() << 8;
            rState = 0;       	// QbyteړǍAŏ
            break;
        default:
            break;
    }
}

/*****  I2C Write Callback *****************/
void I2C1_WriteProcess(void) {
    switch (wState) {
        case 0:
            I2C1_Write((uint8_t)keyDat);
            wState++;		// keyDat̉ʑMA
            break;
        case 1:
            I2C1_Write(keyDat >> 8);
            wState++;		// keyDat̏ʑMA
            break;
        case 2:              	// M
            wState = 0;     	// ŏɖ߂
            break;
        default:
            break;
    }
}
/**** L[XL@******/
uint16_t keyScan(){
    uint8_t kt;
    uint16_t kyw;
    X_A0_SetLow();			// X scan
    SCN_DELAY();
    kyw = ~PORTC & 0x0F;
    X_A0_SetHigh();
    Y_A1_SetLow();			// Y scan
    SCN_DELAY();
    kt = ~PORTC & 0x0F;
    kyw |= (uint16_t)kt << 4;
    Y_A1_SetHigh();
    Z_A2_SetLow();     		// Z scan
    SCN_DELAY();
    kt = ~PORTC & 0x0F;
    kyw |= (uint16_t)kt << 8;
    Z_A2_SetHigh();    
    return kyw; 
}
uint8_t bitCount(uint16_t w){
    uint16_t wsft = 1;
    uint8_t i;
    for (i = 1; i < 13; i++){
        if(w & wsft)   return i;
        wsft <<= 1;
    }
    return 0;
}
/***** C֐ ***************/
void main(void) {
    SYSTEM_Initialize();
    I2C1_Open();                    // I2C1
    
    I2C1_SlaveSetReadIntHandler(I2C1_ReadProcess);
    I2C1_SlaveSetWriteIntHandler(I2C1_WriteProcess);
    
    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();
    X_A0_SetHigh();				// L[s
    Y_A1_SetHigh();
    Z_A2_SetHigh();
    puts("*** Ready ***\n\r");
    while (1){
        keyM = keyScan();
        if(keyM){
            keyP = bitCount(keyM);
            keyDat = (keyM << 4)+(keyP & 0x0F);
            if(keyStat == 0){
                putch(k[keyP - 1]);
                printf(" %04XH\n\r",keyDat);
            }
            keyStat = 1;
            KEY_DELAY();
        }else{
            keyDat = 0;
            keyStat = 0;
        }
    }
}
