/************************(abc899-18325.c)*******************
 *	I2CڑEPROM(24FC1025)ǂݏeXg
 ***********************************************************/

#define DEVICE	0x50        // Blk0=0x50,Blk1=0x54
#define MBFSIZE	78          // pobt@[TCY

#include "mcc_generated_files/mcc.h"
#include "mcc_generated_files/examples/i2c1_master_example.h"
#include "i2cLCD_ST7032i.h"
#include "ctype.h"          // isxdigit()
#include "stdio.h"          // puts(),..
#include "stdlib.h"         // atoi()...
#include "string.h"         // strtok()...
//#include <errno.h>

//=== O[oϐ ========================
char     Dlm[] = ",";       // ؂f~^

//--- VAʐMp
char     RBuf[BFSIZE];      // VAMp
uint8_t  SFlg;           	// VAMtO
char     SBuf[20];       	// 񏈗pobt@[

//--- I2C[p
uint8_t  BlkNum = 0;		// ubNԍ
uint16_t CrtAdr = 0;		// JgAhX
uint8_t  DBuf[MBFSIZE];     // y[Wpobt@[
uint8_t  SQmode;

/*********************************************
 *  I2C EEPROM function
 **********************************************/
//-----  AhXadrA1oCgǂݏo
uint8_t I2C_Mem_Read(uint16_t adr){
    uint8_t bf[2];

    bf[0] = adr >> 8;
    bf[1] = (uint8_t)adr;                // AhXZbg
    I2C1_WriteNBytes(DEVICE + BlkNum,bf,2); // AhXM
    I2C1_ReadNBytes(DEVICE + BlkNum,bf,1);  // f[^Ǎ
    return bf[0];
}

//-----  AhXadrɁA1oCgdt
void I2C_Mem_Write(uint16_t adr, uint8_t dt){
    uint8_t bf[3];

    bf[0] = adr >> 8;
    bf[1] = (uint8_t)adr;                // AhXZbg
    bf[2] = dt;                          // f[^Zbg
    I2C1_WriteNBytes(DEVICE + BlkNum,bf,3); //
    __delay_ms(5);
}
//-----  AhXadr炎oCgary[]ɓǂݏo
void I2C_Mem_NRead(uint16_t adr, uint8_t *ary, uint8_t n){
    uint8_t bf[2];

    bf[0] = adr >> 8;
    bf[1] = (uint8_t) adr;                // AhXZbg
    if(n > MBFSIZE) n = MBFSIZE;
    I2C1_WriteNBytes(DEVICE + BlkNum,bf,2); // AhXM
    I2C1_ReadNBytes(DEVICE + BlkNum,ary,n); // noCgǍ
}

//-----  AhXadrary[]noCg
void I2C_Mem_NWrite(uint16_t adr, uint8_t  *ary, uint8_t n){
    uint8_t bf[MBFSIZE + 2];

    bf[0] = adr >> 8;               // AhXZbg
    bf[1] = (uint8_t) adr;          // y[WEɒӁI
    if(n > MBFSIZE) n = MBFSIZE;
    memcpy(bf+2,ary,n);             // ary[]bf[]ɃRs[
    I2C1_WriteNBytes(DEVICE+BlkNum,bf,n+2); // noCg
    __delay_ms(5);
}

//---- ^[~iɃvvg\
void prtPrompt(uint8_t m){
    if(m)  printf("# ");            // A[h
    else   printf("$ ");            // ʏ폑[h
}

//---- 16i10iɕϊ
int16_t my_xtoi(char *str){
    uint32_t dec;

    dec = strtoul(str,NULL,16);
    if(errno == ERANGE) return -1;  // ϊG[
    return (int16_t)dec;
}

/*********************************************
 * 		R}hANV
 *********************************************/
//----- vR}h   W[aaaa][,][d0,][,]
uint16_t cmd_W(char *str){
    char     *pt;                   // 񑀍p|C^
    uint8_t  last;                  // ̍Ō̈ʒu
    int16_t  res = 0;               // Hexlϊ
    uint8_t  dt = 0;                // ރoCgf[^
    uint16_t cnt = 0;               // ۂɏ񂾃oCg

    if(strlen(str)==1){             // 'W'݂̂Ȃ
        SQmode = 1;                 // A[hɃZbg
        puts("SQmode ON\n\r");
        return 0;                   // f[^͏܂Ȃ
    }
    last = (uint8_t)strlen(str)-1;  // ̍sʒu擾
    if(str[last] == ','){           // sR}Ȃ
        SQmode = 1;                 // A[hɃZbg
        puts("SQmode ON\n\r");
        str[last]='\0';             // s̃R}
    }
    if(str[1]!=','){
        pt = strtok(str+1,Dlm);     // R}h̎
        if(pt != NULL){             // AhXf[^
            res = my_xtoi(pt);
            if(res < 0) return cnt; // ϊG[
            CrtAdr = (uint16_t)res;
        }
        pt = strtok(NULL,Dlm);      // 
    }else{
        pt= strtok(str+1,Dlm);      // 擾
    }

    do{
        if(pt != NULL){
            res = my_xtoi(pt);
            if(res < 0) return cnt;
            dt = (uint8_t)res;
            I2C_Mem_Write(CrtAdr,dt);  // f[^
            sprintf(SBuf,"%d:%04X < %02X",BlkNum,CrtAdr,dt);
            printf("%s\n\r",SBuf);
            LCD_cursor(1,1); LCD_str(SBuf);
            CrtAdr++; cnt++;
            pt = strtok(NULL,Dlm);  // 
        }
    }while(pt != NULL);
    return cnt;
}

//---- qR}h  R[aaaa][,n]
uint16_t cmd_R(char *str){
    char *pt;                   // 񑀍p|C^
    uint16_t n = 1;             // w肳ꂽǍoCg
    int16_t  res = 0;           // Hexlϊ
    uint8_t  dt;                // ǂݍ񂾃oCgf[^
    uint16_t cnt = 0;           // ۂɓǂݏoꂽoCg
    uint8_t  i;                 // [vϐ

    if(strlen(str) > 1){
        if(str[1]==','){
            pt = strtok(str+2,Dlm);
            if(pt != NULL){             // H
                res = my_xtoi(pt);
                if(res < 0) return cnt;
                n = (uint16_t)res;
            }          
        }else{
            pt = strtok(str+1,Dlm);
            if(pt != NULL){             // address
                res = my_xtoi(pt);
                if(res < 0) return cnt;
                CrtAdr = (uint16_t)res;
            }
            pt = strtok(NULL,Dlm);      // 
            if(pt != NULL){             // H
                res = my_xtoi(pt);
                if(res < 0) return cnt;
                n = (uint16_t)res;
            }
        }
    }
    for(i = 0; i < n;i++ ){
        dt = I2C_Mem_Read(CrtAdr);  // oCgf[^ǂݏo
        sprintf(SBuf,"%d:%04X > %02X",BlkNum,CrtAdr,dt);
        printf("%s\n\r",SBuf);
        LCD_cursor(1,1); LCD_str(SBuf);
        CrtAdr++; cnt++;
    }
    SQmode = 0;
//    puts("SQmode OFF");
    return cnt;
}

//---- WSQ R}hiA[hj
uint16_t cmd_WSQ(char *str){
    char     *pt;               // 񑀍p|C^
    uint8_t  dt;                // ރoCgf[^
    int16_t  res;               // Hexlϊ
    uint16_t cnt = 0;           // ۂɓǂݏoꂽoCg
    pt = strtok(str,Dlm);	
    while(pt != NULL){
        res = my_xtoi(pt);
        if(res < 0) return cnt;
        dt = (uint8_t)res;
        I2C_Mem_Write(CrtAdr,dt);  // f[^
        printf("%d:%04X < %02X\n\r",BlkNum,CrtAdr,dt);
        CrtAdr++; cnt++;
        pt = strtok(NULL,Dlm);  // 
    }
    return cnt;
}

//---- MaR}h  MBn[,aaaa]
int cmd_M(char *str){
    char     *pt;               // 񑀍p|C^
    uint8_t  b;                 // oNԍ
    if(str[1] != 'B') return -1;
    pt = strtok(str+2,Dlm);
    if(pt==NULL) return -1;
    b = atoi(pt) & 0x01;
    printf("Bank %d selected\n\r",b);
    BlkNum = b * 4;             // Blk = bit2
    SQmode = 0;
    puts("SQmode OFF\r");
    return b;
}

//---- pR}hiA[h̉j   Q
void cmd_Q(char *str){
    SQmode = 0;
    puts("SQmode OFF\r");
}

//---- t(dump)R}hi64oCg̃f[^DBuf[]ɓǂݏo)
int cmd_U(char *str){
    char     *pt;               // 񑀍p|C^
    int16_t  res;               // Hexlϊ
    uint16_t ad;                // wAhX
    uint8_t  i;                 // [vJE^p

    pt = strtok(str+1,Dlm);
    if(pt != NULL){             // AhXLH
        res = my_xtoi(pt);
        if(res < 0) return -1;
        CrtAdr = (uint16_t)res;
    }
    ad = CrtAdr & 0xFFC0;       // 64oCgPʂ 
    I2C_Mem_NRead(ad,DBuf,64);  // 64oCgDBuf[]ɓǏo
    printf("%d:%04X -  %04X",BlkNum,ad,ad+63);
    for(i=0;i<64;i++){
        if(i % 16 == 0) printf("\n\r");
        printf(" %02X",DBuf[i]);
    }
    puts("\r");
	SQmode = 0;    
    return 0;
}

//---- o(Page)R}hiDBuf[]64oCgɏށj
int cmd_P(char *str){
    char     *pt;               // 񑀍p|C^
    int16_t  res;               // Hexlϊ
    uint16_t ad;                // wAhX
    uint8_t  i;                 // [vJE^p

    if(str[1]!='W') return -1;  // 2vH
    pt = strtok(str+2,Dlm);
    if(pt != NULL){             // AhXLH
        res = my_xtoi(pt);
        if(res < 0) return -1;
        CrtAdr = (uint16_t)res;
    }
    ad = CrtAdr & 0xFFC0;       // 64oCgPʂ
    I2C_Mem_NWrite(ad,DBuf,64); // DBuf[]64oCg
    printf("Page Write %d:%04X -  %04X\n\r",BlkNum,ad,ad+63);
    SQmode = 0;    
    return 0;
}

/********************************************
 *  main apprication 
 ********************************************/
void main(){
    char cmd;
    SYSTEM_Initialize();
    LCD_init();              // LCD

    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();

    puts("ready\r");
    LCD_str("ready");
    prtPrompt(SQmode);

    while(1){
        if(SFlg){
            LCD_clr(); LCD_str(RBuf);
            cmd = RBuf[0];
            printf("\n\r");
            switch(cmd) {
                case 'W': cmd_W(RBuf);	break;
                case 'R': cmd_R(RBuf);	break;
                case 'Q': cmd_Q(RBuf);	break;
                case 'M': cmd_M(RBuf);  break;
                case 'U': cmd_U(RBuf);  break;
                case 'P': cmd_P(RBuf);  break;

                default:  
                        if(SQmode) cmd_WSQ(RBuf);
                        break;
            }
            SFlg = 0;
            prtPrompt(SQmode);
        }
    }
}

/******  End of File **************************/
