/***********************************(AQM1248A_m2.c)*******
 *     AQM1248A OtBbNCuivRamtj
 **********************************************************/

#include "mcc_generated_files/mcc.h"
#include "AQM1248A_m2.h"
#include "Font_5x7.h"
//#include "Font_16x16.h"

static uint8_t vRam[6][128];           // LCD\obt@[

//-------- G-LCD ------------------------------------
void gLCD_int (void){
    gCS_SetLow();                   // `bvZNgL
    gRS_SetLow();                   // R}hf[^w
    SPI1_ExchangeByte(0xAE);   	// Display = OFF
    SPI1_ExchangeByte(0xA0);        // ADC = normal
    SPI1_ExchangeByte(0xC8);   	// C.output = revers
    SPI1_ExchangeByte(0xA3);        // bias = 1/7
    SPI1_ExchangeByte(0x2C);        // power control 1
    __delay_ms(2);                  // 2mSx
    SPI1_ExchangeByte(0x2E);        // power control 2
    __delay_ms(2);                  // 2mSx
    SPI1_ExchangeByte(0x2F);   	    // power control 3
    SPI1_ExchangeByte(0x23);        // Vo ratio set
    SPI1_ExchangeByte(0x81);        // E-volume mode
    SPI1_ExchangeByte(0x1C);        // E-volume value
    SPI1_ExchangeByte(0xA4);        // S_Ȃ
    SPI1_ExchangeByte(0x40);        // start line = 0
    SPI1_ExchangeByte(0xA6);   	// ]Ȃ
    SPI1_ExchangeByte(0xAF);        // Display = ON
    gCS_SetHigh();                  // `bvZNg
}

//-------- G-LCD̃f[^Siwf[^Ŗ߂j---
void gLCD_clr (char dat){			
    uint8_t x, y;
    gCS_SetLow();                   // `bvZNgL
    for(y = 0; y < 6; y++){
        gRS_SetLow();               // R}hw
        SPI1_ExchangeByte(0xB0 + y);
        SPI1_ExchangeByte(0x10);
        SPI1_ExchangeByte(0x00);
        gRS_SetHigh();              // \f[^w
        for(x = 0; x < 128; x++){
            vRam[y][x] = dat;       // vRamNA
            SPI1_ExchangeByte(vRam[y][x]);
        }			
    }
    gCS_SetHigh();                  // `bvZNg
}

//-------- J[\ʒuw -----------------------------------
void gLCD_posXY(uint8_t xpos, uint8_t ypos){
    gCS_SetLow();                   // `bvZNgL
    gRS_SetLow();                   // R}hw
    SPI1_ExchangeByte(0xB0 | (ypos >> 3));
    SPI1_ExchangeByte(0x10 | (xpos >> 4));
    SPI1_ExchangeByte(xpos & 0x0F);
    gCS_SetHigh();                  // `bvZNg
}

//-------- oCgPʂŕ\ixposʒuԂj ---------
uint8_t gLCD_chrX(uint8_t xpos, uint8_t ypos, char chr){
    uint8_t i, yAdr, ptn;
    chr -= 0x20;                    //zAhXvZ
    gLCD_posXY(xpos, ypos);        //\ʒuw
    yAdr = ypos >> 3;
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    for(i = 0; i < 5; i++) {        //f[^Ɏ擾
        ptn = Font[chr][i];
        if(ptn == 0xFF)  break;     //Ȃ甲
        vRam[yAdr][xpos] = ptn;
        SPI1_ExchangeByte(vRam[yAdr][xpos++]);
    }
    vRam[yAdr][xpos] = 0;
    SPI1_ExchangeByte(vRam[yAdr][xpos++]);           //Ԋu󂯂
    gCS_SetHigh();                  // `bvZNg
    return xpos;            //\ʒuԂ
}

//-------- oCgPʂŕ\ixposʒuԂj-----
uint8_t gLCD_strX(uint8_t xpos, uint8_t ypos, char *str){
    while(*str)  xpos = gLCD_chrX(xpos, ypos, *str++);
    return xpos;                    //\ʒuԂ
}

//-------- oCgPʂŃp^[\ixposʒuԂj-
uint8_t gLCD_ptnX(uint8_t xpos, uint8_t ypos, char *ptn, uint8_t n){
    uint8_t i, yAdr;
    gLCD_posXY(xpos, ypos);         // \ʒuw
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    yAdr = ypos >> 3;
    for(i = 0; i < n; i++){
         vRam[yAdr][xpos + i] = *ptn++ ;	
         SPI1_ExchangeByte(vRam[yAdr][xpos + i]);
    }
    gCS_SetHigh();                  // `bvZNg
    return xpos + n;                  // \ʒuԂ
}

//---- oCgPʂn̎wf[^Ŗ߂ixposʒuԂj
uint8_t gLCD_clrX(uint8_t xpos, uint8_t ypos, char dat, uint8_t n){
    uint8_t i, yAdr;
    gLCD_posXY(xpos,ypos);          // \ʒuw
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    yAdr = ypos >> 3;
    for(i = 0; i < n; i++) {
        vRam[yAdr][xpos] = dat;		
        SPI1_ExchangeByte(vRam[yAdr][xpos]);
    }
    gCS_SetHigh();                  // `bvZNg
    return xpos+n;                  // JnʒuԂ
}
/*
//---- oCgPʂ16hbgp^[(Ȃǁj̕\
uint8_t gLCD_nk16X(uint8_t xpos, uint8_t ypos, char *k, uint16_t kj, uint8_t cln){
    uint16_t kk;
 	kk = kj * 2; gLCD_ptnX(xpos, ypos,   (char *)k[kk], cln); 
	kk = kk + 1; xpos = gLCD_ptnX(xpos, ypos+8, (char *)k[kk],cln);
	return xpos;
}*/

/****** hbgPʈʒuŕ` ******/
//----------hbgPʂœ_`----------------------
void gLCD_PSet(uint8_t xpos, uint8_t ypos, uint8_t col){
    uint8_t yAdr, yBit;         // yAhXArbgʒu
    uint8_t ptn = 0x01;       // rbgp^[
    if((xpos > 127) || (ypos > 47))  return;
    yAdr = ypos >> 3; yBit = ypos & 0x07;
    ptn <<= yBit;
    switch(col){
        case 0:	vRam[yAdr][xpos] &= (~ptn); break;
        case 1:	vRam[yAdr][xpos] |= ptn;    break;
        case 8:	vRam[yAdr][xpos] ^= ptn;    break;
    }
    gLCD_posXY(xpos,ypos);  
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    SPI1_ExchangeByte(vRam[yAdr][xpos]);
    gCS_SetHigh();                  // `bvZNg
}

//-------hbgPʂŕ`ixposʒuԂj-------
uint8_t gLCD_PutChr(uint8_t xpos, uint8_t ypos, char ch, uint8_t col){
    uint8_t i, j, ptn, msk;      //rbg}XNf[^
    //LtHgf[^łȂȂ牽Ȃ
    if((ch < 0x20)||(ch > 0x7f)) return xpos;
    ch -= 0x20;                     //zAhXvZ
    for(i = 0; i < 5; i++){
        msk = 0x01;
        ptn = (uint8_t)Font[ch][i];
        if(ptn == 0xFF) break;      //Ȃ甲
        for(j = 0; j < 8; j++){
            if(ptn & msk)    gLCD_PSet(xpos + i,ypos + j,col);
            msk <<= 1;
        }
    } 
//    xpos += i + 1;
//    for(j = 0; j < 8; j++)  gLCD_PSet(xpos,ypos+j,0);
    return xpos + i + 1;
}

//-------hbgPʂŕ`ixposʒuԂj---
uint8_t gLCD_PutStr(uint8_t xpos, uint8_t ypos, char * str, uint8_t col){
    while(*str)                     //I[܂Ōp
        xpos = gLCD_PutChr(xpos,ypos,*str++,col);
    return xpos;                    //\ʒuԂ
}

//-------hbgPʂŃp^[`ixposʒuԂj-------
uint8_t gLCD_PutPtn(uint8_t xpos, uint8_t ypos, char * ptn, uint8_t n, uint8_t col){
    uint8_t i, j, msk;         //rbg}XNf[^
    for(i = 0; i < n; i++){
        msk = 0x01;
        for(j = 0; j < 8; j++){
            if(*ptn & msk)    gLCD_PSet(xpos+i,ypos+j,col);
            msk <<= 1;
        }
        ptn++;
    }
    return xpos + i;
}

// --- ABSASWAP֐`

void swap_uint8_t(uint8_t *a, uint8_t *b){
	uint8_t tmp; tmp = *a; *a = *b; *b = tmp;
}
#define ABS(a)    (((a)>0) ? (a) : -(a))

//----------hbgPʂŒ`-------------------
void gLCD_Line(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t col){
    uint8_t steep, x, y, tmp;
    int   ystep, deltax, deltay, error;
    steep = (ABS(y1 - y0) > ABS(x1 - x0));
    if(steep){    swap_uint8_t(&x0,&y0); swap_uint8_t(&x1,&y1); }
    if(x0 > x1){  swap_uint8_t(&x0,&x1); swap_uint8_t(&y0,&y1); }
    deltax = x1 - x0;                       //  XvZ
    deltay = abs(y1 - y0);
    error = 0;
    y = y0;
    if(y0 < y1) ystep = 1; else ystep = -1;
    for(x = x0; x < x1 + 1; x++){
        if(steep) gLCD_PSet(y,x,col); 
        else      gLCD_PSet(x,y,col);
        error += deltay;
        if((error << 1) >= deltax){
            y += ystep;
            error -= deltax;
        }
    }
}
/*
//---- hbgPʂ16hbgp^[(Ȃǁj̕\
uint8_t Put_nK16(uint8_t xpos, uint8_t ypos, char *k, uint16_t kj, uint8_t cln, uint8_t col){
 	gLCD_PutPtn(xpos, ypos,   (char *)k[kj*2],  cln, col); 
	xpos = gLCD_PutPtn(xpos, ypos+8, (char *)k[kj*2+1],cln, col);
	return xpos;
}*/

/*****  End of File   *****/
