/***********************************(AQM1248A_v2.c)*******
 *     AQM1248A OtBbNCuispi-vRamtj
 **********************************************************/

#include "mcc_generated_files/mcc.h"
#include "AQM1248A_v2.h"
#include "Font_5x7.h"

#include "spi_Mem2.h"

#define VRAM_ADR  0x80000
#define LCG_C_SIZE  128

//static uint8_t vRam[6][128];      // LCD\obt@[(768)
static uint8_t vBf[32];				// (32)

//--- SPI-vRam ANZX֐
uint8_t vRam_read(uint8_t xpos, uint8_t ypos){
	uint32_t adr;
	adr = VRAM_ADR + (uint32_t)ypos * LCG_C_SIZE + xpos;
	return SPI_Mem_Read(adr);
}

void vRam_write(uint8_t xpos, uint8_t ypos, uint8_t dat){
	uint32_t adr;
	adr = VRAM_ADR + (uint32_t)ypos * LCG_C_SIZE + xpos;
	SPI_Mem_Write(adr, dat);
}

void vRam_Nread(uint8_t xpos,uint8_t ypos,char *ptn,uint8_t n){
	uint32_t adr;
	adr = VRAM_ADR + (uint32_t)ypos * LCG_C_SIZE + xpos;
	SPI_Mem_NRead(adr,(uint8_t *)ptn,n);
}

void vRam_Nwrite(uint8_t xpos,uint8_t ypos,char *ptn,uint8_t n){
	uint32_t adr;
	adr = VRAM_ADR + (uint32_t)ypos * LCG_C_SIZE + xpos;
	SPI_Mem_NWrite(adr,(uint8_t *)ptn,n);
}

//-------- G-LCD ------------------------------------
void gLCD_int (void){
    gCS_SetLow();                   // LCDZNgL
    gRS_SetLow();                   // R}hf[^w
    SPI1_ExchangeByte(0xAE);        // Display = OFF
    SPI1_ExchangeByte(0xA0);        // ADC = normal
    SPI1_ExchangeByte(0xC8);        // C.output = revers
    SPI1_ExchangeByte(0xA3);        // bias = 1/7
    SPI1_ExchangeByte(0x2C);        // power control 1
    __delay_ms(2);                  // 2mSx
    SPI1_ExchangeByte(0x2E);        // power control 2
    __delay_ms(2);                  // 2mSx
    SPI1_ExchangeByte(0x2F);   	    // power control 3
    SPI1_ExchangeByte(0x23);        // Vo ratio set
    SPI1_ExchangeByte(0x81);        // E-volume mode
    SPI1_ExchangeByte(0x1C);        // E-volume value
    SPI1_ExchangeByte(0xA4);        // S_Ȃ
    SPI1_ExchangeByte(0x40);        // start line = 0
    SPI1_ExchangeByte(0xA6);        // ]Ȃ
    SPI1_ExchangeByte(0xAF);        // Display = ON
    gCS_SetHigh();                  // LCDZNg
}

//-------- G-LCD̃f[^Siwf[^Ŗ߂j---
void gLCD_clr (char dat){			
    uint8_t x, y;
    gCS_SetLow();                   // gLCDZNgL
    for(y = 0; y < 6; y++){
        gRS_SetLow();               // R}hw
        SPI1_ExchangeByte(0xB0 + y);
        SPI1_ExchangeByte(0x10);
        SPI1_ExchangeByte(0x00);
        gRS_SetHigh();              // \f[^w
        for(x = 0; x < 128; x++){
//            vRam[y][x] = dat;       // vRamNA
//            SPI1_ExchangeByte(vRam[y][x]);
            SPI1_ExchangeByte(dat);
        }
    }
    gCS_SetHigh();                  // LCDZNg
    for(y = 0; y < 6; y++){
        for(x = 0; x < 128; x++){
            vRam_write(x,y,dat);    // vRamNA
        }
    }
}

//-------- J[\ʒuw -----------------------------------
void gLCD_posXY(uint8_t xpos, uint8_t ypos){
    gCS_SetLow();                   // `bvZNgL
    gRS_SetLow();                   // R}hw
    SPI1_ExchangeByte(0xB0 | (ypos >> 3));
    SPI1_ExchangeByte(0x10 | (xpos >> 4));
    SPI1_ExchangeByte(xpos & 0x0F);
    gCS_SetHigh();                  // `bvZNg
}

//-------- oCgPʂŕ\ixposʒuԂj ---------
uint8_t gLCD_chrX(uint8_t xpos, uint8_t ypos, char chr){
    uint8_t i, sx, yAdr, ptn;
    chr -= 0x20;                    //zAhXvZ
    gLCD_posXY(xpos, ypos);         //\ʒuw
    sx = xpos;                      // posxۑ
    yAdr = ypos >> 3;
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    for(i = 0; i < 5; i++) {        //f[^Ɏ擾
        ptn = Font[chr][i];
        if(ptn == 0xFF)  break;     //Ȃ甲
//        vRam[yAdr][xpos] = ptn;
        vBf[i] = ptn;
//        SPI1_ExchangeByte(vRam[yAdr][xpos++]);
        SPI1_ExchangeByte(ptn);
        xpos++;
    }
//    vRam[yAdr][xpos] = 0;
    vBf[i] = 0;
//    SPI1_ExchangeByte(vRam[yAdr][xpos++]);           //Ԋu󂯂
    SPI1_ExchangeByte(0);           //Ԋu󂯂
    xpos++;
    gCS_SetHigh();                  // `bvZNg
    vRam_Nwrite(sx,ypos,(char *)vBf, i);    // vRamɏ 
    return xpos;                    //\ʒuԂ
}

//-------- oCgPʂŕ\ixposʒuԂj-----
uint8_t gLCD_strX(uint8_t xpos, uint8_t ypos, char *str){
    while(*str)  xpos = gLCD_chrX(xpos, ypos, *str++);
    return xpos;                    //\ʒuԂ
}

//-------- oCgPʂŃp^[\ixposʒuԂj-
uint8_t gLCD_ptnX(uint8_t xpos, uint8_t ypos, char *ptn, uint8_t n){
    uint8_t i, yAdr;
    gLCD_posXY(xpos, ypos);         // \ʒuw
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    yAdr = ypos >> 3;
    for(i = 0; i < n; i++){
//         vRam[yAdr][xpos + i] = *ptn++ ;	
//         SPI1_ExchangeByte(vRam[yAdr][xpos + i]);
         SPI1_ExchangeByte(*(ptn + i));
    }
    gCS_SetHigh();                  // `bvZNg
    vRam_Nwrite(xpos,ypos,ptn,n);
    return xpos + n;                  // \ʒuԂ
}

//---- oCgPʂn̎wf[^Ŗ߂ixposʒuԂj
uint8_t gLCD_clrX(uint8_t xpos, uint8_t ypos, char dat, uint8_t n){
    uint8_t i, yAdr;
    gLCD_posXY(xpos,ypos);          // \ʒuw
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
    yAdr = ypos >> 3;
    for(i = 0; i < n; i++) {
//        vRam_write(xpos,yAdr,dat);
//        SPI1_ExchangeByte(vRam[yAdr][xpos]);
        SPI1_ExchangeByte(dat);
    }
    gCS_SetHigh();                  // `bvZNg
    for(i=0;i<<n;i++){
        vRam_write(xpos,ypos,dat);       
    }
    return xpos+n;                  // JnʒuԂ
}

//---- oCgPʂŁicj16hbgp^[(Ȃǁj̕\
/*	xpos: XʒuA	ypos: Yʒu
 *	*pKj: p^[f[^|C^A cdt: hbg
 *---------------------------------------------------- */
uint8_t gLCD_nk16X(uint8_t xpos, uint8_t ypos, char *pKj, uint8_t cdt){
 	gLCD_ptnX(xpos, ypos,(char *)pKj, cdt); 
	xpos = gLCD_ptnX(xpos, ypos+8, (char *)(pKj + cdt),cdt);
	return xpos;
}

/****** hbgPʈʒuŕ` ******/
//----------hbgPʂœ_`----------------------
void gLCD_PSet(uint8_t xpos, uint8_t ypos, uint8_t col){
    uint8_t yAdr, yBit;         // yAhXArbgʒu
    uint8_t ptn = 0x01;         // rbgp^[
    uint8_t dat;
    if((xpos > 127) || (ypos > 47))  return;
    dat = vRam_read(xpos, ypos);
    yAdr = ypos >> 3; yBit = ypos & 0x07;
    ptn <<= yBit;
    switch(col){
        case 0:	dat &= (~ptn);	break;
//                vRam[yAdr][xpos] &= (~ptn); break;
        case 1: dat |= ptn;		break;
//                vRam[yAdr][xpos] |= ptn; 	break;
        case 8: dat ^= ptn;		break;
//                vRam[yAdr][xpos] ^= ptn; 	break;
    }
    gLCD_posXY(xpos,ypos);  
    gCS_SetLow();                   // `bvZNgL
    gRS_SetHigh();                  // \f[^w
//    SPI1_ExchangeByte(vRam[yAdr][xpos]);
    SPI1_ExchangeByte(dat);
    gCS_SetHigh();                  // `bvZNg
    vRam_write(xpos, ypos, dat);
}

//-------hbgPʂŕ`ixposʒuԂj-------
uint8_t gLCD_PutChr(uint8_t xpos, uint8_t ypos, char ch, uint8_t col){
    uint8_t i, j, ptn, msk;      //rbg}XNf[^
    //LtHgf[^łȂȂ牽Ȃ
    if((ch < 0x20)||(ch > 0x7f)) return xpos;
    ch -= 0x20;                     //zAhXvZ
    for(i = 0; i < 5; i++){
        msk = 0x01;
        ptn = (uint8_t)Font[ch][i];
        if(ptn == 0xFF) break;      //Ȃ甲
        for(j = 0; j < 8; j++){
            if(ptn & msk)    gLCD_PSet(xpos + i,ypos + j,col);
            msk <<= 1;
        }
    } 
//    xpos += i + 1;
//    for(j = 0; j < 8; j++)  gLCD_PSet(xpos,ypos+j,0);
    return xpos + i + 1;
}

//-------hbgPʂŕ`ixposʒuԂj---
uint8_t gLCD_PutStr(uint8_t xpos, uint8_t ypos, char * str, uint8_t col){
    while(*str)                     //I[܂Ōp
        xpos = gLCD_PutChr(xpos,ypos,*str++,col);
    return xpos;                    //\ʒuԂ
}

//-------hbgPʂŃp^[`ixposʒuԂj-------
uint8_t gLCD_PutPtn(uint8_t xpos, uint8_t ypos, char * ptn, uint8_t n, uint8_t col){
    uint8_t i, j, msk;         //rbg}XNf[^
    for(i = 0; i < n; i++){
        msk = 0x01;
        for(j = 0; j < 8; j++){
            if(*ptn & msk)    gLCD_PSet(xpos+i,ypos+j,col);
            msk <<= 1;
        }
        ptn++;
    }
    return xpos + i;
}

// --- ABSASWAP֐`

void swap_uint8_t(uint8_t *a, uint8_t *b){
	uint8_t tmp; tmp = *a; *a = *b; *b = tmp;
}
#define ABS(a)    (((a)>0) ? (a) : -(a))

//----------hbgPʂŒ`-------------------
void gLCD_Line(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t col){
    uint8_t steep, x, y, tmp;
    int   ystep, deltax, deltay, error;
    steep = (ABS(y1 - y0) > ABS(x1 - x0));
    if(steep){    swap_uint8_t(&x0,&y0); swap_uint8_t(&x1,&y1); }
    if(x0 > x1){  swap_uint8_t(&x0,&x1); swap_uint8_t(&y0,&y1); }
    deltax = x1 - x0;                       //  XvZ
    deltay = abs(y1 - y0);
    error = 0;
    y = y0;
    if(y0 < y1) ystep = 1; else ystep = -1;
    for(x = x0; x < x1 + 1; x++){
        if(steep) gLCD_PSet(y,x,col); 
        else      gLCD_PSet(x,y,col);
        error += deltay;
        if((error << 1) >= deltax){
            y += ystep;
            error -= deltax;
        }
    }
}

//---- hbgPʂ(cj16hbgp^[(Ȃǁj̕\
/*	xpos: XʒuA	ypos: Yʒu,		col: \[h
 *	*pKj: p^[f[^|C^A	cdt: hbg
 *---------------------------------------------------- */
uint8_t Put_nK16(uint8_t xpos, uint8_t ypos, char *pKj, uint8_t cdt, uint8_t col){
 	gLCD_PutPtn(xpos, ypos, (char *)pKj, cdt, col); 
	xpos = gLCD_PutPtn(xpos, ypos+8, (char *)(pKj + cdt),cdt, col);
	return xpos;
}

/*****  End of File   *****/
