/**********************(abc927-26K80-2.c)************
  *     ECAN eXg  m[hQ   (PIC18F26K80)
 ***************************************************/

#include "mcc_generated_files/mcc.h"
//#include "mcc_generated_files/eusart1.h"

typedef unsigned char BYTE;

#define EU_BFSIZE  120

#define DBF_SIZE    512                 // File/MemorypBFTCY
#define MBF_SIZE    64                  // bZ[WpBFTCY

/***** O[oϐ ***************************/
//--- ^C}[pϐ
    uint8_t TFlg;                       // ^C}[tO

//-----  EUSARTVAp
    char    RBuf[EU_BFSIZE];            // MBuffer
    uint8_t SFlg;                       // MtO

//---- ėpf[^p֐
    char    Msg[MBF_SIZE];              // RgMp
    BYTE    Buf[DBF_SIZE];              // f[^(S/M)pobt@[

// ʕϐ̐錾
uCAN_MSG txAdcResult ;                  // MbZ[Wobt@    
    
/************************************************
  *  ^C}0 Callback֐ (1b荞)      *
 ************************************************/
void TMR0_Process(void){
//    IO_RC2_Toggle();
    TFlg = 1;                           // ^C}[tOZbg
}

/***  EUSARTVA֐ **********************/
    static uint8_t sIdx = 0;            // MIndex
    
/*=== EusartM荞݃nh[ =============*
 *    eusrt.cEUSART_Recive_ISRɒǉ邱  *
 *---------------------------------------------*/
void myEusart(void){

    char ch;
    ch = (char)EUSART1_Read();
    #if ECHO == ON
        EUSART1_Write(ch);
    #endif
    if((ch == 0x0a)||(ch == 0x0d)){     // s
        RBuf[sIdx] = 0;
        sIdx = 0;
        SFlg = 1;
    }else if((ch == 0x08)&&(sIdx > 0)){ // BS
        sIdx--;
    }else{
        if(sIdx < EU_BFSIZE) RBuf[sIdx++] = ch;
    }
}

 uint16_t ad_conv(void){
    // Start the conversion
    ADCON0bits.GO_nDONE = 1;
    // Wait for the conversion to finish
    while (ADCON0bits.GO_nDONE); 
    // Conversion finished, return the result
    return ((uint16_t)((ADRESH << 8) + ADRESL));
 }

/***********************************************
 *   Main application
 ***********************************************/
void main(void){
     union {
          unsigned char c[2] ;
          unsigned int  i ;
     } data ;
     
    SYSTEM_Initialize();
    
    // Timer0 Callback֐
    TMR0_SetInterruptHandler(TMR0_Process);

    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();

    IO_RC2_SetHigh();
    puts("--- start ---\n");
    __delay_ms(3000);
    
    while (1)
    {
        if(TFlg){
            IO_RC2_Toggle();
            TFlg = 0;
            data.i = ad_conv();
            printf("%d\n",data.i);
            txAdcResult.frame.idType = dSTANDARD_CAN_MSG_ID_2_0B ;
            txAdcResult.frame.id     = 0x123 ;
            txAdcResult.frame.dlc    = 2 ;
            txAdcResult.frame.data0  = data.c[0] ;
            txAdcResult.frame.data1  = data.c[1] ;
          // bZ[Wf[^𑗐M
            CAN_transmit(&txAdcResult) ; 
        }
        if(SFlg){
            printf("%s\n",RBuf);
        }
        SFlg = 0;
    }
}
/*********** End of File **********/
