/*****************************(abc928-18326.c)*******
 *      CANW[eXg                         *
 ****************************************************/
#include "myProject.h"
#include "myFunction.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"
#include "i2c_SSD1306.h"

#define GET_SW()    SW0_GetValue()  
//#define GET_SW()    RA3_GetValue() 

#define USE_HCHAR

#ifdef USE_HCHAR
  #define OLED_MX_LN  4                 // ʍŉɔp\
#else
  #define OLED_MX_LN  7                 // ʃtXN[
#endif

// ʕϐ̐錾
char     RBuf[EU_BFSIZE];       // BFSIZEmyProject.hŐ錾
uint8_t  SFlg  = 0;             // VAMtO
uint8_t  CrtLn = 0;             // OLED\ݍs

unsigned char flagRecv = 0 ;    // CANMtO
unsigned char len = 0 ;         // CANM
unsigned char RcvBuf[8];        // CANMf[^

/*==================================================*
*  荞݂̏                                   *
*---------------------------------------------------*/
//----  MCP2515INTs荞
void IOCAF2_Process(void){
    flagRecv = 1 ;              // CANM(LjtOZbg
}

/*==================================================*
 *  tHgf[^                                  *
 *--------------------------------------------------*/
//---- Font data -----
const char hk[11][16] ={
   { 0x00,0xF8,0x04,0x02,0xC2,0x24,0xF8,0x00,
     0x00,0x0F,0x14,0x23,0x20,0x10,0x0F,0x00 },  // 0
   { 0x00,0x10,0x08,0xFE,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00 },  // 1
   { 0x00,0x18,0x04,0x02,0x82,0x44,0x38,0x00,
     0x00,0x38,0x26,0x21,0x20,0x20,0x20,0x00 },  // 2
   { 0x18,0x04,0x82,0x82,0x82,0x44,0x38,0x00,
     0x0C,0x10,0x20,0x20,0x20,0x11,0x0E,0x00 },  // 3
   { 0x00,0xC0,0x30,0x0C,0xFE,0x00,0x00,0x00,
     0x03,0x02,0x02,0x02,0x3F,0x02,0x02,0x00 },  // 4
   { 0xE0,0x5E,0x22,0x22,0x22,0x42,0x80,0x00,
     0x0C,0x10,0x20,0x20,0x20,0x10,0x0F,0x00 },  // 5
   { 0xF0,0x8C,0x42,0x42,0x42,0x84,0x00,0x00,
     0x0F,0x10,0x20,0x20,0x20,0x10,0x0F,0x00 },  // 6
   { 0x02,0x02,0x02,0x02,0xE2,0x1A,0x06,0x00,
     0x00,0x00,0x00,0x7E,0x01,0x00,0x00,0x00 },  // 7
   { 0x38,0x44,0x82,0x82,0x82,0x44,0x38,0x00,
     0x0E,0x11,0x20,0x20,0x20,0x11,0x0E,0x00 },  // 8
   { 0x78,0x84,0x02,0x02,0x02,0x84,0xF8,0x00,
     0x08,0x10,0x21,0x21,0x21,0x10,0x0F,0x00 },   // 9
   { 0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
     0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00 }   // :
};

const char sp[16] = {
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 };  // space

const char as[6][16] ={
   { 0x00,0xC0,0x38,0x06,0x38,0xC0,0x00,0x00,
     0x3C,0x03,0x02,0x02,0x02,0x03,0x3C,0x00 },  // A
   { 0xFE,0x82,0x82,0x82,0xC4,0x38,0x00,0x00,
     0x3F,0x20,0x20,0x20,0x20,0x11,0x0E,0x00 },  // B
   { 0xF0,0x0C,0x02,0x02,0x02,0x04,0x08,0x00,
     0x07,0x18,0x20,0x20,0x20,0x10,0x08,0x00 },  // C
   { 0xFE,0x02,0x02,0x02,0x04,0x18,0xE0,0x00,
     0x3F,0x20,0x20,0x20,0x10,0x0C,0x03,0x00 },  // D
   { 0xFE,0x82,0x82,0x82,0x82,0x82,0x02,0x00,
     0x3F,0x20,0x20,0x20,0x20,0x20,0x20,0x00 },  // E
   { 0xFE,0x82,0x82,0x82,0x82,0x82,0x02,0x00,
     0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00 }   // F
};

const char kj[2][32]={
   { 0x00,0x10,0x60,0x01,0x06,0x04,0xE4,0x24,
     0x2F,0x24,0xE4,0x24,0x2F,0x24,0xE4,0x04,
     0x00,0xC0,0x30,0x0C,0x03,0x90,0x95,0x55,
     0x55,0x35,0x1F,0x35,0x55,0x55,0x91,0x90 },  // 
   { 0x00,0x1C,0x04,0x04,0x24,0x24,0x24,0x24,
     0xA7,0xA4,0x64,0x24,0x04,0x04,0x1C,0x00,
     0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x82,
     0xFF,0x02,0x02,0x02,0x02,0x02,0x02,0x02 },  // 
};

/*==================================================*
 *  OLED\p֐  \eXg֐                *
 *--------------------------------------------------*/

void test_Msg(void){
    i2cOLED_posPX(0,68);
    i2cOLED_str("Test Print!");    
}

void test_HanK(void){
    uint8_t i;
    for(i = 0; i <= 9; i++)
        i2cOLED_Ptn(4,i*8,2,8,(char *)hk[i]);
    for(i = 0; i  < 6;  i++)
        i2cOLED_Ptn(4,80+i*8,2,8,(char*)as[i]);
}

void test_Kanj(void){
    uint8_t i;
    for(i = 0; i < 2; i++)
        i2cOLED_Ptn(6,90+i*16,2,16,(char *)kj[i]);
}

void test_Ascii(void){
    char c;
    i2cOLED_posPX(0,0);
    for(c = 0x30; c <= 0x39; c++)  i2cOLED_chr(c);
    i2cOLED_posPX(2,0);
    for(c = 0x41; c <= 0x50; c++)  i2cOLED_chr(c);
    i2cOLED_posPX(3,0);
    for(c = 0x61; c <= 0x71; c++)  i2cOLED_chr(c);
}

//---- p̕\
uint8_t i2cPrint_Hstr(uint8_t py, uint8_t x, char *str){
    uint8_t n;
    uint8_t xpos;
    xpos = x;
    while(*str){
        n = *str;
        if((0x30<=n)&(n<=0x3A)){
            n -= 0x30;
            xpos = i2cOLED_Ptn(py,xpos,2,8,(char *)hk[n]);
        }else if((0x41<=n)&(n<=0x46)){
            n -= 0x41;
            xpos = i2cOLED_Ptn(py,xpos,2,8,(char *)as[n]);
        }else{
            xpos = i2cOLED_Ptn(py,xpos,2,8,(char *)sp);
        }
        str++;
    }
	return xpos;
}

//---- XN[t\
//      (XN[͈͂[0-OLED_MX_LN]j
void i2cOLED_Prt(char *str){
    i2cOLED_posPX(CrtLn,0);
    i2cOLED_str(str);
    if(CrtLn < OLED_MX_LN) CrtLn++;
    else                   CrtLn = 0;
    i2cOLED_Clr(CrtLn,CrtLn,0);
}

/*===================================================*
 *  CANM̏                                  *
 *---------------------------------------------------*/
void CheckReceiveProcess(void) {
    union {  unsigned char c[2] ;
             unsigned int  i ;
          }   data ;
    unsigned long id ;
    char buf[16];

    // INTs荞݂LΏ
    if(flagRecv) {
        flagRecv = 0 ;              // 荞݃tONA
        while (CAN_MSGAVAIL == mcp_checkReceive()) {
            // MbZ[Wǂݍ,
            mcp_readMsgBuf(&len, RcvBuf);
            // f[^t[Ȃ珈
            if (mcp_isRemoteRequest() == 0) {
                id = mcp_getCanId() ;
                switch (id) {
                    case 0x123 : // ϒRl̎ʎqID
                        data.c[0] = RcvBuf[0] ;
                        data.c[1] = RcvBuf[1] ;
                   //     sprintf(buf,"%8d",data.i);				
                        sprintf(buf, "%03X:%8d",  (uint16_t)id,  data.i );
//                       my_xtoa(buf, id, 3);  buf[3]=':'; buf[4]=' ';											
//                        my_utoa(buf + 5, data.i);
                        i2cOLED_Prt(buf) ; EU_Puts(buf);
                     #ifdef USE_HCHAR
                        i2cOLED_Clr(6,7,0);
                        i2cPrint_Hstr(6, 0, buf);   // p\
                     #endif
                        break ;
                    default :    // ̑̎ʎqID
                        i2cOLED_Prt(" Unknown") ;
                        break ;
                }
            }
        }
    }
}

//---- CANMeXg
void test_CAN(uint8_t *buf){
    mcp_sendMsgBuf(0x123,CAN_STDID,CAN_RMTFRM,0,buf,1) ;
}

/********************************************************
 *       Main application                               *
 ********************************************************/
void main(void){
    uint8_t cmd;                    // R}h
    uint8_t  buf[8] ;               // CANf[^p
    uint8_t sw, sw_lst;          // XCb`
    
    char msg[]  = "ready!";
    char msg1[] = "Init OK!";
    char msg2[] = "Resieved!";
    char msg3[] = "Switch Pushed!";
 
    SYSTEM_Initialize();
    SSP1CON1bits.SSPEN = 1;         //SPI1L
        
    IOCAF2_SetInterruptHandler(IOCAF2_Process);
    
    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();

    i2cOLED_init();
    i2cOLED_Clr(0,7,0);
    i2cOLED_Prt(msg); EU_Puts(msg); 

    // MCP2515ɂCANʐM̏(RC6CSsƂ)
    // CANoXʐMx=100Kbps  MCP2515̃NbN=8MHz
    while (CAN_OK != mcp_begin(CAN_100KBPS,MCP_8MHz)) {
         i2cOLED_Prt("InitFail") ;
         while(1) ;               // I
    } 
    i2cOLED_Prt(msg1); EU_Puts(msg1);
    // MASK0->Filter0->RXB0(I[ot[RXB1)̂ݎgp܂B
    mcp_init_Mask(0, 0, 0x3ff) ;  // SĎt
    mcp_init_Filt(0, 0, 0x123) ;  // ID:0x123̂ݎ󂯎

    // MCP2515INTs荞݂̐ݒ
    IOCAN2 = 1 ;           // RA2IOCŐݒ(GbWŊݔ)
    IOCAF2 = 0 ;           // tONA
    IOCIF  = 0 ;
    IOCIE  = 1 ;           // ԕω荞݂Lɂ
    sw_lst = GET_SW() ;    // ŐṼXCb`̏

    while (1) {
        sw = GET_SW() ;
        if((sw == 0)&(sw_lst==1)){      // XCb`̗Ŏs
            sw_lst = sw;                // ݃XCb`lL
//            i2cOLED_Prt(msg3); EU_Puts(msg3);
			test_CAN(buf);
//            mcp_sendMsgBuf(0x123,CAN_STDID,CAN_RMTFRM,0,buf,1) ;
//            i2cOLED_Prt(msg2); EU_Puts(msg2);
            while( GET_SW() );          //; L[܂ő҂
            __delay_ms(100);             // `^Oh~100mS҂ 
            sw_lst = 1;
        }
        // MĂ郁bZ[Wf[^𒲂ׂ
        CheckReceiveProcess() ;

        if(SFlg){                       // VA͂
            cmd = RBuf[0];
            switch(cmd){
                case 'C': i2cOLED_Clr(0,7,0); CrtLn = 0;  break;
                case 'F': test_Ascii();                 break;
                case 'S': test_Msg();                   break;
                case 'H': test_HanK();                  break;
                case 'K': test_Kanj();                  break;
                case 'R': test_CAN(buf);                  break;
            } 
            SFlg = 0;
        }
    }
}
/*************** End of File **********************/
