/***********************************(abc930-18326.c)********
 *		CAN test (MCP25625)
 ***********************************************************/

//#include "mcc_generated_files/mcc.h"
//#include "mcc_generated_files/examples/i2c1_master_example.h"
#include "myProject.h"
#include "myFunction.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"
#include "i2c_LCD_lib.h"

#define  ADT_ADR  0x48                  // ADT I2CAhX

#define EU_BFSIZE  120
#define MBF_SIZE    64                  // bZ[WpBFTCY

/***** O[oϐ ***************************/
//--- ^C}[pϐ
uint8_t TFlg;                           // ^C}[tO
//-----  EUSARTVAp
char    RBuf[EU_BFSIZE];                // MBuffer
uint8_t SFlg;                           // MtO
//    static uint8_t sIdx = 0;          // MIndex
		
//---- ėpf[^p
char    Msg[MBF_SIZE];                  // RgMp

//---- CANpʕϐ̐錾
char    flagRecv = 0 ;                  // CANMLtO
uint8_t R_len = 0 ;                     // CANMf[^TCY
char    RcvBuf[9];                      // CANMf[^
uint8_t S_len = 0 ;                     // CANMf[^TCY
char    SndBuf[9];                      // CANMf[^
uint8_t T_Snd = 1;                      // xMtO
		
/************************************************
  *  ^C}0 Callback֐ (1b荞)      *
 ************************************************/
void TMR0_Process(void){
    TFlg = 1;                           // ^C}[tOZbg
}

//----  MCP2515INTs荞
void IOCAF2_Process(void){
     flagRecv = 1 ;                     // CANLtOZbg
}

/************************************************/
//---- xf[^̌vZ
uint16_t calc_Temp(char *bf, uint16_t tDat){
	uint16_t tp;
    if(tDat & 0x8000){                    	// Ȃ
        tp = ((8192 - (tDat >> 3)) * 10) / 16;
        sprintf(bf,"-%2d.%1dC", tp / 10, tp % 10);
    }else{                               	// 
        tp = ((tDat >> 3) * 10) / 16;
        sprintf(bf,"%3d.%1dC", tp / 10, tp % 10);
    }
	return tp;
}

//---- xf[^̕\ ----
uint16_t prt_Temp(uint16_t tDat){
    uint16_t  tp;
    sprintf(Msg,"Tmp:%04X",tDat);
    EU_Write(Msg);
    LCD_clr(); LCD_str(Msg);
    tp = calc_Temp(SndBuf, tDat);
    EU_Puts(SndBuf);
    LCD_cursor(1,1); LCD_str(SndBuf);
    return tp;
}

//--- xf[^̎擾
uint16_t get_ADT7410(void){
    uint16_t temp;
    I2C2_ReadNBytes(ADT_ADR,(uint8_t *)&temp,2); // xf[^Ǎ
    temp = (temp<<8) | ((uint8_t)(temp>>8));     // ㉺oCgf[^
    prt_Temp(temp);
    return temp;
}

/*------------------------------------------------*
 *  CANM̏                                 *
 *------------------------------------------------*/
void CAN_Receive(void){
    unsigned long id ;

    while (CAN_MSGAVAIL == mcp_checkReceive()) {
        // MbZ[Wǂݍ,
        mcp_readMsgBuf(&R_len, (uint8_t *)RcvBuf);
        // f[^t[Ȃ珈
        if (mcp_isRemoteRequest() == 0) {
            id = mcp_getCanId() ;
            switch (id) {
                case 0x123 :
                    data.c[0] = RcvBuf[0] ;
                    data.c[1] = RcvBuf[1] ;
                    sprintf(Msg,"%03X:%8d",(uint16_t)id,data.i);
                    EU_Puts(Msg);	 //LCD_str(buf);
                    break ;
                default :         // ̑̎ʎqID
                    LCD_str(" Unknown") ;
                    break ;
            }
        }
    }
}

//---- CANM{iWAf[^t[AMςݑ҂j
/*      uint32_t  id:	11rbgʎq
 *      uint8_t	*buf:	Mf[^AhX
 *      uint8_t  len:	MoCg* 
 *-----------------------------------------*/
void CAN_Send(uint32_t id, uint8_t *buf, uint8_t n){
    uint8_t res;
    if(n == 0)
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_RMTFRM,0,buf,1) ;
    else
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_DTFRM,n,buf,1) ;
    sprintf(Msg,"%x:%d",id,res);
    EU_Puts(Msg);
}

/*******************************************************
 *    Main application
 *******************************************************/
void main(void){
    uint8_t d[] = { 0x30, 0x40 };
    char cmd;
    uint8_t *p, n;

    // initialize the device
    SYSTEM_Initialize();
    SSP1CON1bits.SSPEN = 1;
    LCD_init();

    TMR0_SetInterruptHandler(TMR0_Process); // Timer0 Callback֐
    IOCAF2_SetInterruptHandler(IOCAF2_Process);	// PinCallBack
		
    
    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();

    // MCP2515ɂCANʐM̏
    // CANoXʐMx=100Kbps  MCP25625̃NbN=16MHz
    while (CAN_OK != mcp_begin(CAN_100KBPS,MCP_16MHz)) {
        LCD_str("InitFail") ;
        while(1) ;                     // I
    } 
    LCD_str("Init OK!") ;
    // MASK0->Filter0->RXB0(I[ot[RXB1)̂ݎgp܂B
    mcp_init_Mask(0, 0, 0x3ff) ;        // SĎt
    mcp_init_Filt(0, 0, 0x123) ;        // ID:0x123̂ݎ󂯎
    // MCP2515INTs荞݂̐ݒ
    IOCAN2 = 1 ;                        // RA2ŗGbW
    IOCAF2 = 0 ;                        // RA2tONA
    IOCIF  = 0 ;                        // tONA
    IOCIE  = 1 ;                        // ԕω荞݂L
		
    EU_Puts("--- Ready\n");             //  LCD_str("Ready");

    while (1){
        if(TFlg){    
            TFlg = 0;
            get_ADT7410();
            S_len = (uint8_t)strlen(SndBuf);
            p = (uint8_t *)SndBuf;
            if(T_Snd)                       // xM[hȂ
                CAN_Send(0x123, p, S_len);
        }
        if(flagRecv) {
            flagRecv = 0 ;                  // 荞݃tONA
            CAN_Receive();                  // CANMf[^擾E
        }
        if(IO_RA3_GetValue()==0){           // RA3Ă
            T_Snd ^= 1;                     // xM[hύX
            while(IO_RA3_GetValue() == 0);  // L[܂ő҂
            __delay_ms(100);
        }
        if(SW0_GetValue()==0){              // SW0Ă
            d[0] ^= 1;                      // rbg0𔽓]
            CAN_Send(0x149,d,1);            // f[^1CANM
            while(SW0_GetValue() == 0);     // L[܂ő҂
            __delay_ms(100);
        }
        if(SFlg){                           // VA͗LH
            EU_Puts(RBuf);
            cmd = RBuf[0];
            p = (uint8_t *)RBuf;
            n = (uint8_t)strlen(RBuf) - 1;
            if(n > 8) n = 8;
            switch(cmd){			
                case 'T': T_Snd ^= 1;            break;	// xM[hύX				
                case 'R': CAN_Send(0x123,p,0);   break;	// [gM				
                case 'S': CAN_Send(0x149,p+1,n); break; // CANM
            }
            SFlg = 0;		
       }
    }
}
/*********** end of file ********************/
