/***********************************(abc931-1240.c)******
 *      CAN test (MCP25625BO)         m[hV      *
 ********************************************************/

//#include "mcc_generated_files/mcc.h"
#include "myProject.h"
//#include "myFunction.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"

// ʕϐ̐錾

unsigned char flagRecv  = 0;    // CANMtO
unsigned char R_len     = 0;    // CANM
unsigned char RcvBuf[8];        // CANMf[^

/**************************************************
 *	CANM                                     *
 *------------------------------------------------*/
//--- CANM
void CAN_Receive(void){
    union {  unsigned char c[2] ;
             unsigned int  i ;
          }   data ;
    unsigned long id ;

    while (CAN_MSGAVAIL == mcp_checkReceive()) {
        // MbZ[Wǂݍ,
        mcp_readMsgBuf(&R_len, (uint8_t *)RcvBuf);
        // f[^t[Ȃ珈
        if (mcp_isRemoteRequest() == 0) {
            id = mcp_getCanId() ;
            switch (id) {
                case 0x149 :    
                    if(RcvBuf[0] & 1)   IO_RA5_SetHigh();
                     else               IO_RA5_SetLow() ;
                    break ;
            }
        }
    }
}

/*---- CANM{iWAt[Mςݑ҂j
 *		uint32_t  id:	11rbgʎq
 *		uint8_t	 *bf:	Mf[^AhX
 *		uint8_t    n:	MoCg* 
 *-----------------------------------------*/
void CAN_Send(uint32_t id, uint8_t *bf, uint8_t n){
    uint8_t res;
    if(n == 0)
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_RMTFRM,0,bf,1) ;
    else
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_DTFRM,n,bf,1) ;
}

/***************************************************
 *		Main application
 ***************************************************/
void main(void){
    uint8_t bf[8];
    
    // initialize the device
    SYSTEM_Initialize();
    SSP1CON1bits.SSPEN = 1;

    //INTERRUPT_GlobalInterruptEnable();
    //INTERRUPT_PeripheralInterruptEnable();

    IO_RA5_SetHigh(); 
	__delay_ms(1000);         
    // MCP25625BOɂCANʐM̏
    // CANoXʐMx=100Kbps  MCP25625̃NbN=16MHz
    while (CAN_OK != mcp_begin(CAN_100KBPS,MCP_16MHz)) {
        __delay_ms(500);
        IO_RA5_Toggle();            // G[ȂLED_
    }
	IO_RA5_SetLow() ;
    // MASK0->Filter0->RXB0(I[ot[RXB1)̂ݎgp܂B
    mcp_init_Mask(0, 0, 0x3ff) ;    // SĎt
    mcp_init_Filt(0, 0, 0x149) ;    // ID:0x149̂ݎ󂯎

    while (1) {
        // CANMLȂ
        if(mcp_checkReceive()==CAN_MSGAVAIL){
            CAN_Receive();              // f[^̎擾Ə
        }
        // SWĂ
        if(IO_RA3_GetValue()==0){
            bf[0]= 0x4F; bf[1]= 0x4B;   // 'OK'𑗂
            CAN_Send(0x131, bf, 2);     // id=0x131őM
            while(IO_RA3_GetValue()==0); // ܂ő҂
            __delay_ms(100);
        }
    }
}
/****************** End of File ************/
