/********************************************
 *      OLED library  (i2c_SSD1306.c)       *
 *      use for 0.96OLED  ,....             *
 ********************************************/

#include "myProject.h"
#include "Font_5x7.h"
//#include "i2c_SSD1306.h"

#define I2COLED_ADR     0x3C            // 0x3D
#define TEST_BF_SIZE    72
#define OLED_BF_SIZE    TEST_BF_SIZE + 2

#define HORIZONTAL      0x00            // AhX[h
#define VERTICAL        0x01            // AhX[h
#define PAGE_ADDR       0x02            // y[W[h

uint8_t OLED_MODE;
uint8_t gBf[OLED_BF_SIZE];

void set_OLED_HorMode(){
    gBf[0] = 0x00;
    gBf[1] = 0x20; gBf[2] = 0;          // AhX[h
    gBf[3] = 0x21; gBf[4] = 0; gBf[5] = 127;
    gBf[6] = 0x22; gBf[7] = 0; gBf[8] = 7;
    I2C2_WriteNBytes(I2COLED_ADR, gBf,9);
}
    
//----- Set Draw Area (for Hor/Ver Mode)-------
void i2cOLED_RangePX(uint8_t p0,uint8_t p1, uint8_t x0, uint8_t x1){
    gBf[0] = 0x00;                      // ARg[w	
    gBf[1] = 0x20; gBf[2] = 0;          // [hw
    gBf[3] = 0x21; gBf[4] = x0; gBf[5] = x1;    // ͈(x0-x1))
    gBf[6] = 0x22; gBf[7] = p0; gBf[8] = p1;    // y[W͈(p0-p1)
    I2C2_WriteNBytes(I2COLED_ADR, gBf,9);
}

//----- Cursor X,Y (for Page Mode)--------------
void i2cOLED_posPX(uint8_t pg, uint8_t cX){
//    set_OLED_HorMode();
    i2cOLED_RangePX(0,7,0,127);
    gBf[0] = 0x00;                      // ARg[w
    gBf[1] = 0x20; gBf[2] = 0x02;       // Page[hw
    gBf[3] = 0xB0 + (pg & 0x07);        // pageAhXw (0xB0-B7)
    gBf[4] = cX & 0x0F;                 // (x)ʒu4rbgw
    gBf[5] = 0x10 + ((cX >> 4) & 0x07); // (x)ʒu3rbgw
    I2C2_WriteNBytes(I2COLED_ADR, gBf,6);
}

//-------- clear LINE --------------------------
void i2cOLED_LnClr(uint8_t pg, uint8_t dt){
    uint8_t i;
    i2cOLED_posPX(pg,0);                // y[W[hňʒuw
    gBf[0]=0x40;                        // f[^Rg[w
    for(i=1;i<=65;i++) gBf[i]=dt;
    I2C2_WriteNBytes(I2COLED_ADR, gBf,65);
    I2C2_WriteNBytes(I2COLED_ADR, gBf,65);
}

//-------- clear OLED --------------------------
void i2cOLED_Clr(uint8_t p0, uint8_t p1,uint8_t dt){
	uint8_t i;
    for(i = p0; i <= p1; i++){
        i2cOLED_LnClr(i,dt);
    }
    i2cOLED_posPX(p0,0);
}

//------ OLED5x7\ ------------
//     Oi2cOLED_posPXňʒuw肵Ă
void i2cOLED_chr (char dat){
    char i;
    dat -= 0x20;                        // zAhXvZ
    gBf[0] = 0x40;                      // f[^Rg[w 
    for(i=0; i<5; i++) {
        gBf[i+1] = Font[dat][i];
        if(gBf[i+1] == 0xFF) break;     // Ȃ甲
    }
    gBf[i+1]=0;                         // 1hbg󂯂
    I2C2_WriteNBytes(I2COLED_ADR, gBf,i+2);     
}

//------ OLED5x7(v|[Vij\ ------
void i2cOLED_str(char *str){
    while(*str)  i2cOLED_chr(*str++);  //pointer increment
}

//------ OLEDɃp^[\
uint8_t i2cOLED_Ptn(uint8_t pg,uint8_t cx,uint8_t pn, uint8_t xn, char *ptn){
    uint8_t i; 
    i2cOLED_RangePX(pg,pg+pn-1,cx,cx+xn-1); // [hŃGAw
    gBf[0] = 0x40;                      // f[^Rg[w
    for(i = 1; i <= pn*xn; i++){
        gBf[i] = *ptn++;
    }
    I2C2_WriteNBytes(I2COLED_ADR, gBf, pn*xn+1);
    return cx+xn;
}

//------ OLED̏  ------------------
void i2cOLED_init(void){
    __delay_ms(50);                     // 20ms wait
    uint8_t Cmds[]={
                0x00,                   // ARg[w
                0xA8,0x3F,              // C 64s
                0xD3,0x00,              // \ItZbg
                0x40,                   // \JnC0(6rbgj
//                0xA1,                 // E] 0xA0:/0xA1:
//                0xC8,                 // ㉺] 0xC0:/0xC8:
 //               0xDA,0x02,            // \[hAlternative
 //               0x81,0x7F,            // RgXg= 127(/0-255)
 //               0xA4,                 // `̋H
 //               0xA6,                 // ] A6:/A7F]
 //               0xD5,0x80,            // NbN䁁128
 //               0x20,0x00,            // AhX[hhorizontal
                0x8D,0x14,              // `[W|vݒ(K{)
                0xAF                    // \Jn
                };
    I2C2_WriteNBytes(I2COLED_ADR, Cmds,9);  //MoCgɍ킹
}

//-----  Test for SSD1306 ----
void ssd1306_test(){
//    uint8_t startCmd[] = {0x80,0xA5};
    uint8_t areaCmd[] ={
                0x00,                   // oCg(Aj
                0x20, 0,                // [h
                0x21, 96,127,           // XGAw,
                0x22, 2, 3              // YGAw
                };
//    uint8_t endCmd[] = { 0x80,0xA4 };

    gBf[0] = 0x40;                      // f[^Rg[w
    for (int i = 1; i <= 64; i++){
        gBf[i] = (uint8_t)(i-1);
    }
//    I2C2_WriteNBytes(I2COLED_ADR, startCmd,2);
    I2C2_WriteNBytes(I2COLED_ADR, areaCmd,9);
    I2C2_WriteNBytes(I2COLED_ADR, gBf, 64);
//    I2C2_WriteNBytes(I2COLED_ADR, endCmd,2);
}

/********  End of File ******/
